//Pooya Gozlo
//CS 143
//Long HW, final Sudoku assignment
//HW Core Topics: recursive backtracking
//thiis program loads two sudoku boards, checks if they are valid or solve and tries to solve them using recursive backtracking

import java.io.FileNotFoundException;

public class SudokuSolverEngine {


// pre: the sdk files must exist and be formatted correctly
// post: loads and tests both sudoku boards, then prints the results

    public static void main(String[] args) throws FileNotFoundException {
        testBoard("very-fast-solve-1.sdk");
        System.out.println("\n-------------------------\n");
        testBoard("fast-solve-1.sdk");
    }

    // pre: file n ame must be a valid path file of a sudoku puzzle
    // post: prints the initial state, determines if the puzzle is invalid or  solved then attempts to solve it. prints the result or error message
    public static void testBoard(String fileName) throws FileNotFoundException {
        System.out.println("=== Testing Board: " + fileName + " ===");

        SudokuBoard board = new SudokuBoard(fileName);

        System.out.println("Initial board:");
        System.out.println(board);
        System.out.println();

        if (!board.isValid()) {
            System.out.println("Board cannot be solved (invalid state).");
        } else if (board.isSolved()) {
            System.out.println("Board is already solved.");
        } else {
            System.out.print("Solving board...");
            long start = System.currentTimeMillis();

            boolean solved = board.solve();

            long stop = System.currentTimeMillis();
            System.out.printf("SOLVED in %.3f seconds.\n", ((stop - start) / 1000.0));
            System.out.println();

            if (solved) {
                System.out.println("Solved board:");
                System.out.println(board);
            } else {
                System.out.println("No solution exists for this board.");
            }
        }
    }
}

/*
 
  ----jGRASP exec: java -ea SudokuSolverEngine
 === Testing Board: very-fast-solve-1.sdk ===
 Initial board:
 . 3 4 | 6 7 8 | 9 1 2 
 . 7 2 | 1 9 5 | 3 4 8 
 1 9 8 | 3 4 2 | 5 6 7 
 ------+-------+------
 . . 9 | . 6 1 | 4 2 3 
 . 2 6 | 8 5 3 | 7 9 1 
 . 1 3 | 9 2 4 | . 5 6 
 ------+-------+------
 . 6 1 | 5 3 7 | 2 8 4 
 . 8 . | 4 1 9 | 6 3 5 
 3 4 5 | . 8 6 | 1 7 9 
 
 
 Solving board...SOLVED in 0.007 seconds.
 
 Solved board:
 5 3 4 | 6 7 8 | 9 1 2 
 6 7 2 | 1 9 5 | 3 4 8 
 1 9 8 | 3 4 2 | 5 6 7 
 ------+-------+------
 8 5 9 | 7 6 1 | 4 2 3 
 4 2 6 | 8 5 3 | 7 9 1 
 7 1 3 | 9 2 4 | 8 5 6 
 ------+-------+------
 9 6 1 | 5 3 7 | 2 8 4 
 2 8 7 | 4 1 9 | 6 3 5 
 3 4 5 | 2 8 6 | 1 7 9 
 
 
 -------------------------
 
 === Testing Board: fast-solve-1.sdk ===
 Initial board:
 8 2 7 | 1 5 4 | 3 9 6 
 9 6 5 | . 2 7 | 1 4 8 
 3 4 1 | 6 . 9 | 7 5 2 
 ------+-------+------
 . . . | . . . | . . . 
 . . . | . . . | . . . 
 6 1 8 | 9 7 . | 4 3 5 
 ------+-------+------
 7 8 6 | 2 3 5 | . 1 4 
 1 5 4 | 7 9 6 | 8 . 3 
 2 3 9 | 8 4 . | . . . 
 
 
 Solving board...SOLVED in 0.010 seconds.
 
 Solved board:
 8 2 7 | 1 5 4 | 3 9 6 
 9 6 5 | 3 2 7 | 1 4 8 
 3 4 1 | 6 8 9 | 7 5 2 
 ------+-------+------
 4 7 2 | 5 1 3 | 6 8 9 
 5 9 3 | 4 6 8 | 2 7 1 
 6 1 8 | 9 7 2 | 4 3 5 
 ------+-------+------
 7 8 6 | 2 3 5 | 9 1 4 
 1 5 4 | 7 9 6 | 8 2 3 
 2 3 9 | 8 4 1 | 5 6 7 
 
 
  ----jGRASP: Operation complete.
 
*/
